/*
ͻ
 NAME      : STARINTF.PAS                                                    
 FUNCTION  : Interfacing functions and procedures for the serial driver      
           : STARCOMM.EXE. C Language listing for STARCOMM used as a         
           : simple T.S.R. BIOS, or as a DOS DEVICE DRIVER...                
 VERSION   : 2.23                                                            
 LANGUAGE  : TURBO C v1.0 and laters.                                        
 REMARKS   : All the functions refered to be "I" DO return UN_CHECKED if they
           : are called whereas "Check_STARCOMM_Present" has not been called 
           : yet. All the functions refered "II" DO return UN_OPENED if they 
           : are called whereas "Open_COMM" has not been called yet.         
           : Therefore, to use this library, you have to call...             
           : * at the beginning of the program:                              
           :   - "Check_STARCOMM_present" to check the driver is seted in RAM
           :   - "Open_COMM" when the driver is used as a DEVICE DRIVER, and 
           :     if you want to use it from the DOS interrupt 21h.           
           :   - "Open_Port" to activate the needed serial ports.            
           : * at the end of the program:                                    
           :   - "Close_Port" to reset all modem signals to 0 and to close   
           :     all the serial ports.                                       
           :   - "Close_COMM" if the driver is used as a DEVICE DRIVER.      
           : Please, report yourself to STAR_REF.DOC to get any information  
           : you need on these procedures and functions...                   
 COPYRIGHT : HETRU Fabrice 1991-1996.                                        
ͼ
*/


#define TRUE         1
#define FALSE        0
#define UN_CHECKED   20
#define UN_OPENED    21


#define byte         unsigned char
#define word         unsigned int


#include <mem.h>
/* CPU registers access. */
#include <dos.h>
union  REGS  inregs,outregs;
struct SREGS segregs;
/* General globals variables. */
static byte RS_accessible = FALSE;     /* Is the driver loaded in memory ?   */
static byte ComExist[8]; /* What serial ports do exists? (from "Port_Opened")*/
static word CommPort = 0;      /* Designated port: 0 (COM1:) to 7 (COM8:)    */
static word Format;
static byte Voie_active, Pret, Clear_to_send, Sonnerie, Porteuse,
            dDSR, dCTS, dRI, dDCD;
static byte Buff_overflow, Engorgement, Parite, Stop_bit, Break_it;
static unsigned BasePort1 = 0x03F8;
static unsigned BasePort2 = 0x02F8;
static unsigned BasePort3 = 0x03E8;
static unsigned BasePort4 = 0x02E8;
static byte RTS_CTS  = 1;
static byte DTR_DSR  = 2;
static byte BothCmde = 3;
static byte RI       = 4;
static byte DCD      = 5;
static byte OUT1     = 6;
static byte Inactif   =  0;
static byte Local     = 76; /*'L'*/
static byte Eloigne   = 69; /*'E'*/
static byte Bilateral = 66; /*'B'*/
static byte Xon  = 0x11;
static byte Xoff = 0x13;
static byte NonActif = 0; /* Smode0: Erroneous bytes will be stored in the */
                          /* receiving buffer exactly as they are decoded. */
static byte Remplace = 1; /* Smode1: U/S bytes are subtitued...            */
static byte RempNULL = 2; /* Smode2: U/S bytes are lost. The lost bytes    */
                          /* counter is incremented for each erroneous byte*/
static byte NoBreakBuff = 100; /* Pas de code de BREAK en buffer de rcp... */
static byte BreakOnBuff = 200; /* Code spcial de BREAK voulu en rcp...    */
/* Variables for STARCOMM used as a DEVICE DRIVER. */
static char NomDevice[9] = {'C','O','M','M',' ',' ',' ',' ','\0'};
static word handler_voie_serie;
static char port_ouvert = FALSE;
/* Computer architectural type. */
static byte Type_PC = 1;
static byte Type_XT = 2;
static byte Type_AT = 3;
static byte PS2_PC  = 4;
static byte PS2_AT  = 5;


/* ========= SPECIFICS PROCEDURES FOR THE LIBRARY VERSION OF S.M. ========== */
/* void Set_SCL(void);  */
/* void UnSetSCL(void); */
/* void SCLservs(void); */


/* ====================== BIOS INTERRUPT 14h PROCEDURES ==================== */
byte Version(char *NumVer)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 6;
    int86(0x14,&inregs,&outregs);
    NumVer[0] = outregs.h.al;
    NumVer[1] = '.';
    outregs.x.ax = outregs.x.di;
    NumVer[2] = outregs.h.ah;
    NumVer[3] = outregs.h.al;
    NumVer[4] = 0;
    return(TRUE);
    }
  else
    {
    NumVer[0] = 0;
    return(UN_CHECKED);
    }
  }


byte Open_Port()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 7;
    inregs.h.al = 0;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte OpenPort_Buff(word Segment, word Offset, word Taille_in, word Taille_out)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 7;
    inregs.h.al = 6;
    inregs.x.dx = CommPort;
    segregs.es = Segment;
    inregs.x.di = Offset;
    inregs.x.bx = Taille_in;
    inregs.x.cx = Taille_out;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Close_Port(byte ProtegeBuff)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 7;
    if (ProtegeBuff) inregs.h.al = 1; else inregs.h.al = 7;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Port_Opened()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 7;
    inregs.h.al = 2;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    if (CommPort<8)
      {
      if (outregs.h.ah==5) ComExist[CommPort]=FALSE;
        else ComExist[CommPort]=TRUE;
      }
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte Interdit_Port()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x0A;
    inregs.h.al = 0;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Autorise_Port()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x0A;
    inregs.h.al = 1;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte EtatVerrouilleComm(byte *Mode)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x0A;
    inregs.h.al = 6;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    *Mode = outregs.h.al;
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte VerrouilleComm(byte Mode)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x0A;
    inregs.h.al = Mode;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte SLOW_Ems()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 7;
    inregs.h.al = 3;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte FAST_Ems()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 7;
    inregs.h.al = 4;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Send_SLOW()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 7;
    inregs.h.al = 5;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


void Get_Ports_Adresses()
  {
  movedata(0x40,0x00,FP_SEG(&BasePort1),FP_OFF(&BasePort1),8);
  }


byte Infos_Uart(byte *Uart_type, word *Uart_adresse, byte *Irq,
     byte *FIFO_actif, byte *Taille_FIFO)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 9;
    inregs.h.al = 0;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    *Uart_type = outregs.h.al;
    *Uart_adresse = outregs.x.bx;
    *Irq = outregs.h.ch;
    if (outregs.h.cl==0)
      {
      *FIFO_actif = FALSE;
      *Taille_FIFO = 1;
      }
    else
      {
      *FIFO_actif = TRUE;
      *Taille_FIFO = outregs.h.cl;
      }
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Set_New_Uart(word Uart_adresse,byte Irq,byte FIFO_actif,byte Taille_FIFO)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 9;
    inregs.h.al = 1;
    inregs.x.dx = CommPort;
    inregs.x.bx = Uart_adresse;
    inregs.h.ch = Irq;
    if (FIFO_actif) inregs.h.cl = Taille_FIFO;
      else inregs.h.cl = 0;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Infos_BoardPort(byte *Port_Board, word *Port_adresse, byte *Port_masque,
     byte *Port_Logique)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 9;
    inregs.h.al = 2;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    *Port_Board = outregs.h.al;
    *Port_adresse = outregs.x.bx;
    *Port_masque = outregs.h.ch;
    *Port_Logique = outregs.h.cl;
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Set_New_BoardPort(word Board_adresse, byte Masque, byte Logique)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 9;
    inregs.h.al = 3;
    inregs.x.dx = CommPort;
    inregs.x.bx = Board_adresse;
    inregs.h.ch = Masque;
    inregs.h.cl = Logique;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Unset_BoardPort()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 9;
    inregs.h.al = 3;
    inregs.x.dx = CommPort;
    inregs.x.bx = 0;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Infos_Buffs(byte *Nb_actifs, byte *Nb_maxi, word *Taille_InBuff,
     word *Taille_OutBuff)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x0D;
    int86(0x14,&inregs,&outregs);
    *Taille_InBuff = outregs.x.bx;
    *Taille_OutBuff = outregs.x.cx;
    *Nb_actifs = outregs.h.dh;
    *Nb_maxi = outregs.h.dl;
    return(FALSE);
    }
  else return(UN_CHECKED);
  }


byte Init_Port(byte longueur, byte stop_bit, byte parity, long word vitesse,
     word *Taille_InBuff, word *Taille_OutBuff)
  {
  byte descripteur_format, vitess;

  switch (longueur)
    {
    case '5': {descripteur_format = 0; break;}
    case '6': {descripteur_format = 1; break;}
    case '7': {descripteur_format = 2; break;}
    case '8': {descripteur_format = 3; break;}
    default : return(TRUE);
    }
  switch (stop_bit)
    {
    case '1': break;
    case '2': {descripteur_format = descripteur_format + 0x04; break;}
    default : return(TRUE);
    }
  switch (parity)
    {
    case 'n':
    case 'N': break;
    case 'i':
    case 'I': {descripteur_format = descripteur_format + 8; break;}
    case 'p':
    case 'P': {descripteur_format = descripteur_format + 24; break;}
    case 't':
    case 'T': {descripteur_format = descripteur_format + 40; break;}
    case 'r':
    case 'R': {descripteur_format = descripteur_format + 56; break;}
    default : return(TRUE);
    }
  switch (vitesse)
    {
    case   110: {vitess = 0; break;}
    case   150: {vitess = 1; break;}
    case   300: {vitess = 2; break;}
    case   600: {vitess = 3; break;}
    case  1200: {vitess = 4; break;}
    case  2400: {vitess = 5; break;}
    case  4800: {vitess = 6; break;}
    case  9600: {vitess = 7; break;}
    case 19200: {vitess = 8; break;}
    case 28800: {vitess = 9; break;}
    case 38400: {vitess = 10; break;}
    case 57600: {vitess = 11; break;}
    case 115200: {vitess = 12; break;}
    default : return(TRUE);
    }
  inregs.h.bl = descripteur_format;
  inregs.h.bh = vitess;
  inregs.x.dx = CommPort;
  inregs.h.ah = 0x0B;
  if (RS_accessible)
    {
    int86(0x14,&inregs,&outregs);
    *Taille_InBuff = outregs.x.bx;
    *Taille_OutBuff = outregs.x.cx;
    return(FALSE);
    }
  else return(UN_CHECKED);
  }


byte Init_status()
  {
  static byte buff[3];
  /* */
  if (RS_accessible)
    {
    segregs.es = FP_SEG(&buff[0]);
    inregs.x.di = FP_OFF(&buff[0]);
    inregs.x.dx = CommPort;
    inregs.h.ah = 0x0C;
    int86x(0x14,&inregs,&outregs,&segregs);
    Format = (buff[1]*256) + buff[2];
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Reset_Init_status(word Format)
  {
  if (RS_accessible)
    {
    inregs.x.bx = Format;
    inregs.x.dx = CommPort;
    inregs.h.ah = 0x0B;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte flush_buffers()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x0E;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte flush_InBuff()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x0F;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte flush_OutBuff()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x10;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte ResetCOM_and_TimMAX(byte RdTim_MAX, byte *Old_RdTim_MAX,
     byte WrTim_MAX, byte *Old_WrTim_MAX)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x11;
    inregs.h.bh = RdTim_MAX;
    inregs.h.bl = WrTim_MAX;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    *Old_RdTim_MAX = outregs.h.bh;
    *Old_WrTim_MAX = outregs.h.bl;
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Status_Trait_Erreurs(byte *mode, byte *codeEr, byte *codeBk)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x12;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    *mode = outregs.h.al;
    *codeEr = outregs.h.bl;
    *codeBk = outregs.h.bh;
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Def_Trait_Erreurs(byte mode, byte code)
  {
  if (RS_accessible)
    {
    inregs.h.al = mode;
    inregs.h.bl = code;
    inregs.x.dx = CommPort;
    inregs.h.ah = 0x13;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Change_com_port(byte Num_port)
  {
  if (RS_accessible)
    {
    CommPort = Num_port;
    inregs.x.dx = CommPort;
    inregs.h.ah = 0x08;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Attend_Buff_ems_vide(byte Temps_maxi)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x1B;
    inregs.h.al = Temps_maxi;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte CheckBufferIn(word *Nb_a_lire)
  {
  if (RS_accessible)
    {
    inregs.x.dx = CommPort;
    inregs.h.ah = 0x1C;
    int86(0x14,&inregs,&outregs);
    *Nb_a_lire = outregs.x.cx;
    if ( (outregs.h.ah==0) & (outregs.h.al==0) ) return(TRUE);
      else return(FALSE);
    }
  else return(UN_CHECKED);
  }


byte CheckBufferOut(word *Nb_libre)
  {
  if (RS_accessible)
    {
    inregs.x.dx = CommPort;
    inregs.h.ah = 0x1D;
    int86(0x14,&inregs,&outregs);
    *Nb_libre = outregs.x.cx;
    if ( (outregs.h.ah==0) & (outregs.h.al==0) ) return(TRUE);
      else return(FALSE);
    }
  else return(UN_CHECKED);
  }


byte ReadSerie(byte *car, word nombre, word *Nb_received)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x14;
    inregs.x.cx = nombre;
    segregs.es = FP_SEG(car);
    inregs.x.di = FP_OFF(car);
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    *Nb_received = outregs.x.cx;
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte WriteSerie(byte *car, word nombre, word *Nb_written)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x15;
    inregs.x.cx = nombre;
    segregs.es = FP_SEG(car);
    inregs.x.di = FP_OFF(car);
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    *Nb_written = outregs.x.cx;
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte ReadCarSerie(byte *car)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x16;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    *car = outregs.h.al;
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte WriteCarSerie(byte car)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x17;
    inregs.h.al = car;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Peek_rcp(byte *car)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x18;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    *car = outregs.h.al;
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte Poke_rcp(byte car)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x19;
    inregs.h.al = car;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte WriteCmde(byte *Cmde, byte nombre, byte UseDTR)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x1A;
    segregs.es = FP_SEG(Cmde);
    inregs.x.di = FP_OFF(Cmde);
    inregs.h.al = nombre;
    inregs.h.bh = UseDTR;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte etat_du_modem()
  {
  static byte buff[10];
  /* */
  if (RS_accessible)
    {
    inregs.h.ah = 0x20;
    inregs.h.al = 0;
    segregs.es = FP_SEG(&buff[0]);
    inregs.x.di = FP_OFF(&buff[0]);
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    Voie_active = buff[0] + 0x30 + 1;
    if (buff[1]==1) Pret = TRUE;
      else Pret = FALSE;
    if (buff[2]==1) Clear_to_send = TRUE;
      else Clear_to_send = FALSE;
    if (buff[3]==1) Sonnerie = TRUE;
      else Sonnerie = FALSE;
    if (buff[4]==1) Porteuse = TRUE;
      else Porteuse = FALSE;
    dDSR = buff[6];
    dCTS = buff[7];
    dRI = buff[8];
    dDCD = buff[9];
    if (buff[5]==1) return(TRUE);
      else return(FALSE);
    }
  else return(UN_CHECKED);
  }


byte set_DTR()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x20;
    inregs.h.al = 1;
    inregs.x.di = 0x01;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte clear_DTR()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x20;
    inregs.h.al = 2;
    inregs.x.di = 0xFE;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte set_RTS()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x20;
    inregs.h.al = 1;
    inregs.x.di = 0x02;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte clear_RTS()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x20;
    inregs.h.al = 2;
    inregs.x.di = 0xFD;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte set_OUT1()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x20;
    inregs.h.al = 1;
    inregs.x.di = 0x04;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte clear_OUT1()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x20;
    inregs.h.al = 2;
    inregs.x.di = 0xFB;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Send_break(byte duree)
  {
  if (RS_accessible)
    {
    inregs.h.bl = duree;
    inregs.h.ah = 0x1E;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Errors_Report()
  {
  static byte buff[5];
  /* */
  if (RS_accessible)
    {
    inregs.h.ah = 0x1F;
    segregs.es = FP_SEG(&buff[0]);
    inregs.x.di = FP_OFF(&buff[0]);
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    Buff_overflow = buff[0];
    Engorgement = buff[1];
    Parite = buff[2];
    Stop_bit = buff[3];
    Break_it = buff[4];
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte Port_free()
  {
  if (RS_accessible)
    {
    inregs.x.dx = CommPort;
    inregs.h.ah = 0x25;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte HandShake_Status(byte Proto_type, byte *SendEnabled)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x21;
    inregs.h.al = Proto_type;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    *SendEnabled = (byte)outregs.x.di;
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte HandShake_Setup(byte Proto_type, byte state)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x22;
    inregs.h.al = Proto_type;
    inregs.h.bh = state;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte XonoffShaking_Status(byte *SendEnabled, byte *Nb_Xoff)
  {
  static byte buff[5];
  /* */
  if (RS_accessible)
    {
    inregs.h.ah = 0x23;
    segregs.es = FP_SEG(&buff[0]);
    inregs.x.di = FP_OFF(&buff[0]);
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    Xon = buff[0];
    Xoff = buff[1];
    *Nb_Xoff = buff[2];
    *SendEnabled = buff[3];
    return(buff[4]);
    }
  else return(UN_CHECKED);
  }


byte XonoffShaking_Setup(byte state)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x24;
    inregs.h.al = state;
    inregs.h.bh = Xon;
    inregs.h.bl = Xoff;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Set_routine(word Segprog, word Ofsprog, word *OldSeg, word *OldOfs)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x26;
    segregs.es = Segprog;
    inregs.x.di = Ofsprog;
    inregs.x.dx = CommPort;
    int86x(0x14,&inregs,&outregs,&segregs);
    *OldSeg = segregs.es;
    *OldOfs = outregs.x.di;
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte Unset_routine()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x27;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Set_err_routine(word Segprog, word Ofsprog, word *OldSeg, word *OldOfs)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x28;
    segregs.es = Segprog;
    inregs.x.di = Ofsprog;
    int86x(0x14,&inregs,&outregs,&segregs);
    *OldSeg = segregs.es;
    *OldOfs = outregs.x.di;
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte Unset_err_routine()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x29;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Verrouille()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2A;
    inregs.h.al = 1;
    inregs.h.bl = 1;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte Deverrouille()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2A;
    inregs.h.al = 1;
    inregs.h.bl = 0;
    int86(0x14,&inregs,&outregs);
    return(TRUE);
    }
  else return(UN_CHECKED);
  }


byte GetDeviceName()
  {
  char Nom[9];

  strcpy(Nom,"        ");
  if (RS_accessible)
    {
    inregs.h.ah = 0x2B;
    segregs.es = FP_SEG(&Nom[0]);
    inregs.x.di = FP_OFF(&Nom[0]);
    int86(0x14,&inregs,&outregs);
    if (outregs.h.ah==0) strcpy(NomDevice,Nom);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte GetPortDevice()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2C;
    inregs.h.al = 0;
    int86(0x14,&inregs,&outregs);
    if (outregs.h.ah==0) return(outregs.h.al); else return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte ResetPortDevice()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2C;
    inregs.h.al = 1;
    inregs.x.dx = CommPort;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.ah);
    }
  else return(UN_CHECKED);
  }


byte EmulBIOS()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2D;
    inregs.h.al = 0;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte SetEmulBIOS(byte status)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2D;
    inregs.h.al = 1;
    inregs.h.bl = status;
    int86(0x14,&inregs,&outregs);
    }
  else return(UN_CHECKED);
  }


byte OrdiType()
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2E;
    inregs.h.al = 0;
    int86(0x14,&inregs,&outregs);
    return(outregs.h.al);
    }
  else return(UN_CHECKED);
  }


byte SetOrdiType(byte status)
  {
  if (RS_accessible)
    {
    inregs.h.ah = 0x2E;
    inregs.h.al = 1;
    inregs.h.bl = status;
    int86(0x14,&inregs,&outregs);
    }
  else return(UN_CHECKED);
  }


/* ================== DEVICE DRIVER MODE SPECIFICS PROCEDURES ============== */
word Open_COMM()
  {
  word error;
  /* */
  if (! port_ouvert)
    {
    inregs.h.ah = 0x3D;
    segregs.ds = FP_SEG(NomDevice);
    inregs.x.dx = FP_OFF(NomDevice);
    inregs.h.al = 2;
    intdosx(&inregs,&outregs,&segregs);
    if (outregs.x.cflag != 0)
      {
      port_ouvert = FALSE;
      error = outregs.x.ax;
      }
    else
      {
      handler_voie_serie = outregs.x.ax;
      port_ouvert = TRUE;
      error = 0;
      }
    }
  else error = 0;
  return(error);
  }


word Close_COMM()
  {
  if (port_ouvert)
    {
    inregs.h.ah = 0x3E;
    inregs.x.bx = handler_voie_serie;
    intdos(&inregs,&outregs);
    if (outregs.x.cflag != 0) return(outregs.x.ax);
      else
        {
        port_ouvert = FALSE;
        return(0);
        }
    }
  else return(0);
  }


byte IOStream_READ(byte *RTS_type, byte *DTR_type, byte *RI_type,
     byte *DCD_type, byte *OUT1_type, byte *Xonoff_type)
  {
  static byte buff[10];
  /* */
  if (port_ouvert)
    {
    inregs.h.ah = 0x44;
    inregs.h.al = 2;
    inregs.x.cx = 11;
    segregs.ds = FP_SEG(&buff[0]);
    inregs.x.dx = FP_OFF(&buff[0]);
    inregs.x.bx = handler_voie_serie;
    intdosx(&inregs,&outregs,&segregs);
    if (outregs.x.cflag==0)
      {
      Voie_active = buff[0] + 0x30 + 1;
      Format = (buff[1] * 256) + buff[2];
      *RTS_type  = buff[3];
      *DTR_type  = buff[4];
      *RI_type   = buff[5];
      *DCD_type  = buff[6];
      *OUT1_type = buff[7];
      *Xonoff_type = buff[8];
      Xon = buff[9];
      Xoff = buff[10];
      return(FALSE);
      }
    else return(TRUE);
    }
  else return(UN_OPENED);
  }


byte IOStream_WRITE(byte RTS_type, byte DTR_type, byte RI_type, byte DCD_type,
     byte OUT1_type, byte Xonoff_type)
  {
  static byte buff[10];
  /* */
  if (port_ouvert)
    {
    buff[0] = Voie_active - 0x30 - 1;
    inregs.x.ax = Format;
    buff[1] = inregs.h.ah;
    buff[2] = inregs.h.al;
    buff[3] = RTS_type;
    buff[4] = DTR_type;
    buff[5] = RI_type;
    buff[6] = DCD_type;
    buff[7] = OUT1_type;
    buff[8] = Xonoff_type;
    buff[9] = Xon;
    buff[10] = Xoff;
    inregs.h.ah = 0x44;
    inregs.h.al = 3;
    inregs.x.cx = 11;
    segregs.ds = FP_SEG(&buff[0]);
    inregs.x.dx = FP_OFF(&buff[0]);
    inregs.x.bx = handler_voie_serie;
    intdosx(&inregs,&outregs,&segregs);
    if (outregs.x.cflag==0) return(FALSE);
      else return(TRUE);
    }
  else return(UN_OPENED);
  }


byte CheckCOMMIn()
  {
  if (port_ouvert)
    {
    inregs.h.ah = 0x44;
    inregs.h.al = 6;
    inregs.x.bx = handler_voie_serie;
    intdos(&inregs,&outregs);
    if (outregs.h.al==0) return(FALSE);
      else return(TRUE);
    }
  else return(UN_OPENED);
  }


byte CheckCOMMOut()
  {
  if (port_ouvert)
    {
    inregs.h.ah = 0x44;
    inregs.h.al = 7;
    inregs.x.bx = handler_voie_serie;
    intdos(&inregs,&outregs);
    if (outregs.h.al==0) return(TRUE);
      else return(FALSE);
    }
  else return(UN_OPENED);
  }


int ReadCOMM(byte *car, word nombre)
  {
  if (port_ouvert)
    {
    inregs.h.ah = 0x3F;
    inregs.x.bx = handler_voie_serie;
    inregs.x.cx = nombre;
    segregs.ds = FP_SEG(car);
    inregs.x.dx = FP_OFF(car);
    intdosx(&inregs,&outregs,&segregs);
    if (outregs.x.cflag != 0) return(outregs.x.ax);
      else
        {
        if (outregs.x.ax != 0) return(0);
          else return(-1);
        }
    }
  else return(UN_OPENED);
  }


int WriteCOMM(byte *car, word nombre)
  {
  if (port_ouvert)
    {
    inregs.h.ah = 0x40;
    inregs.x.bx = handler_voie_serie;
    inregs.x.cx = nombre;
    segregs.ds = FP_SEG(car);
    inregs.x.dx = FP_OFF(car);
    intdosx(&inregs,&outregs,&segregs);
    if (outregs.x.cflag != 0) return(outregs.x.ax);
      else
        {
        if (outregs.x.ax != 0) return(0);
          else return(-1);
        }
    }
  else return(UN_OPENED);
  }


/* =============== SPECIAL PROCEDURE TO SCAN STARCOMM IN MEMORY ============ */
byte Check_STARCOMM_Present()
  {
  static byte check;

  check=0;
  inregs.h.ah=6;
  inregs.h.al=0;
  int86(0x14,&inregs,&outregs);
  if ( (outregs.h.ah==0) & (outregs.h.al!=0) )
    {
    RS_accessible = TRUE;
    check=1;
    }
  else RS_accessible = FALSE;
  if (RS_accessible)
    {
    if (GetDeviceName()==0) check=2;
    }
  return(check);
  }
